 /* 'mrSurface.h' */

 /* Nagwek bazowych typw Mirus */
#include "mrDatatypes.h"
 /* Nagowek definicji bdw Mirus */
#include "mrError.h"
 /* Nagwek obrazu Mirus RGBA */
#include "mrRGBAImage.h"
 /* Nagwek ekranu Mirus */
#include "mrScreen.h"
/* Plik nagwka grafiki DirectX */
#include <d3d8.h> 

 /* Zaczaj tylko raz */
#pragma once

 /* Klasa powierzchni Mirus */
class mrSurface
{
protected:
  /* Powierzchnia Direct3D */
 LPDIRECT3DSURFACE8 m_pkD3DSurface;
 mrRGBAImage *      m_pkRawImage;

public:
  /* Konstruktory / Destruktor */
 mrSurface (void);
 ~mrSurface (void);

  /* Procedury manipulujce powierchni */
 mrError32 Create (mrRGBAImage * pkRawImage);
 mrError32 Update (void);
 mrError32 Render (POINT * pkDestPoint, RECT * pkSourceRect = NULL);

  /* Procedury obsugowe powierchni */
 void SetRawImage (mrRGBAImage * pkRawImage);
 mrRGBAImage * GetRawImage (void);
};
